#include<iostream.h>
#import"c:\drvlinx4\common\kpcidio.dll"
using namespace KPCIDIOLib;

int main()
{
	unsigned char data;
	if(FAILED(CoInitialize(NULL)))
	{
		cout << "Unable to initialize COM" << endl;
		return 1;
	}
	
	try
	{
		// Follow smart pointer declaration will create
		// an instance of the KPCIPIO object.
		IKPCIPIOPtr pdio(__uuidof(KPCIPIO));
		pdio->OpenDevice(0); //Open KPCIPIO device
		pdio->Write(3,0x8); //Make ports A, B, and CL outputs, Port CH input
		pdio->Write(2,0x5); //Write port C value to CL
		data=pdio->Read(2); //read back port C, including port CH
		cout << "Port C value = 0x" << hex << static_cast<unsigned>(data) << endl;
		pdio->CloseDevice();
			
	}
	catch (const _com_error& Err)
	{
		// Use a separate try/catch blocks around statements to make
		// error handling statement specific.
		cout << "Error using KPCIPIO" << endl;
		cout << "Error number is 0x" << hex << Err.Error() << endl;
		cout << "Error message is " << Err.ErrorMessage() << endl;
		// Display error description if rich error info supported
		if (Err.ErrorInfo())
			cout << Err.Description() << endl;
		return 1;
	}

	// Closes the COM library on the current thread,
	// unloads all DLLs loaded by the thread,
	// frees any other resources that the thread maintains,
	// and forces all RPC connections on the thread to close.
	cout << "Closing COM" << endl;
	CoUninitialize();
	char      ch[8];
	cout << "Hit <Enter> to exit..." << endl;
	cin.get(ch, 8);
	return 0;
}
